/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.entity;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import svenhjol.charm.block.GlowballBlobBlock;
import svenhjol.charm.module.Glowballs;

public class GlowballEntity
extends ProjectileItemEntity {
    public GlowballEntity(EntityType<? extends GlowballEntity> entityType, World world) {
        super(entityType, world);
    }

    public GlowballEntity(World world, LivingEntity owner) {
        super(Glowballs.GLOWBALL, owner, world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public GlowballEntity(World world, double x, double y, double z) {
        super(Glowballs.GLOWBALL, x, y, z, world);
    }

    protected Item func_213885_i() {
        return Glowballs.GLOWBALL_ITEM;
    }

    protected void func_70227_a(RayTraceResult hitResult) {
        super.func_70227_a(hitResult);
        this.func_70106_y();
        if (!this.field_70170_p.field_72995_K) {
            if (hitResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                this.tryPlaceBlob(this.field_70170_p, (BlockRayTraceResult)hitResult);
            } else if (hitResult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                this.tryHitEntity((EntityRayTraceResult)hitResult);
            }
        }
    }

    private void tryPlaceBlob(World world, BlockRayTraceResult hitResult) {
        PlayerEntity player;
        BlockPos pos = hitResult.func_216350_a();
        Direction side = hitResult.func_216354_b();
        BlockState state = world.func_180495_p(pos);
        BlockPos offsetPos = pos.func_177972_a(side);
        BlockState offsetState = world.func_180495_p(offsetPos);
        if (state.func_224755_d((IBlockReader)world, pos, side) && (world.func_175623_d(offsetPos) || offsetState.func_185904_a() == Material.field_151586_h && (Integer)offsetState.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0)) {
            BlockState placedState = (BlockState)Glowballs.GLOWBALL_BLOCK.func_176223_P().func_206870_a((Property)GlowballBlobBlock.FACING, (Comparable)side);
            if (offsetState.func_177230_c() == Blocks.field_150355_j) {
                placedState = (BlockState)placedState.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
            }
            world.func_180501_a(offsetPos, placedState, 2);
            world.func_184133_a(null, offsetPos, SoundEvents.field_232740_iI_, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return;
        }
        if (this.func_234616_v_() instanceof PlayerEntity && !(player = (PlayerEntity)this.func_234616_v_()).func_184812_l_()) {
            world.func_184133_a(null, pos, SoundEvents.field_232740_iI_, SoundCategory.PLAYERS, 0.7f, 1.0f);
            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((IItemProvider)Items.field_151114_aO, 1)));
        }
    }

    private void tryHitEntity(EntityRayTraceResult hitResult) {
        Entity entity = hitResult.func_216348_a();
        entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), 1.0f);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

